<?php

namespace FirstpointCh\LunarSwisspost\Extensions;

use Filament\Tables\Table;
use FirstpointCh\LunarSwisspost\Actions\GenerateBarcodesBulkAction;
use Lunar\Admin\Support\Extending\ResourceExtension;

class OrderRessourceExtension extends ResourceExtension
{
	public function extendTable(Table $table): Table
	{
		return $table->bulkActions([
			...$table->getBulkActions(),
			GenerateBarcodesBulkAction::make('generate_barcodes')
				->deselectRecordsAfterCompletion(),
		]);
	}
}
