<?php

use Illuminate\Support\Facades\Route;

$authMiddleware = class_exists(\Filament\Http\Middleware\Authenticate::class)
    ? \Filament\Http\Middleware\Authenticate::class
    : 'auth';

Route::middleware(['web', $authMiddleware])
    ->name('lunar-swisspost.')
    ->prefix('lunar-swisspost')
    ->group(function () {
        Route::get('tracking-numbers/{trackingNumber}/label', 'FirstpointCh\\LunarSwisspost\\Http\\Controllers\\DownloadLabelController')
            ->name('labels.download');

        Route::get('tracking-numbers/{trackingNumber}/pdf', 'FirstpointCh\\LunarSwisspost\\Http\\Controllers\\DownloadPdfController')
            ->name('labels.download-pdf');
    });

