<?php

namespace FirstpointCh\LunarSwisspost\Http\Auth;

use GuzzleHttp\Client;
use Illuminate\Support\Facades\Cache;

class Authenticator
{
    protected $client;
    protected $clientId;
    protected $clientSecret;
    protected $baseUrl;

    public function __construct()
    {
        $this->client = new Client();
        $this->clientId = config('swisspost.client_id');
        $this->clientSecret = config('swisspost.client_secret');
        $this->baseUrl = 'https://api.post.ch';
    }

    public function getAccessToken(string $scope = 'DCAPI_BARCODE_READ')
    {
        if (Cache::has('swisspost_access_token_'.strtolower($scope))) {
            return Cache::get('swisspost_access_token_'.strtolower($scope));
        }

        $response = $this->client->post($this->baseUrl . '/OAuth/token', [
            'form_params' => [
                'grant_type' => 'client_credentials',
                'client_id' => $this->clientId,
                'client_secret' => $this->clientSecret,
                'scope' => $scope,
            ],
            'headers' => [
                'Content-Type' => 'application/x-www-form-urlencoded',
            ],
        ]);

        if ($response->getStatusCode() !== 200) {
            throw new \Exception(__("Failed to retrieve access token. Status: ") . $response->getStatusCode());
        }

        $data = json_decode($response->getBody(), true);
        $accessToken = $data['access_token'];
        $expiresIn = $data['expires_in'];

        Cache::put('swisspost_access_token_'.strtolower($scope), $accessToken, $expiresIn / 60);

        return $accessToken;
    }
}
