<?php

namespace FirstPoint\LunarSaferpay;

use FirstPoint\LunarSaferpay\Components\SaferpayPaymentButton;
use Illuminate\Support\ServiceProvider;
use Lunar\Facades\Payments;
use Livewire\Livewire;

class SaferpayPaymentServiceProvider extends ServiceProvider
{
    public function register()
    {
        $this->mergeConfigFrom(__DIR__.'/../config/lunar-saferpay.php', 'lunar-saferpay');
    }

    public function boot()
    {
        Payments::extend('saferpay', function ($app) {
            return $app->make(SaferpayPaymentDriver::class);
        });

        if ($this->app->runningInConsole()) {
            $this->publishes([
                __DIR__.'/../config/lunar-saferpay.php' => config_path('lunar/payments/saferpay.php'),
            ], 'lunar');
        }

        $this->loadViewsFrom(__DIR__.'/../resources/views', 'lunar-saferpay');
        
        Livewire::component('saferpay-payment-button', SaferpayPaymentButton::class);

        $this->loadRoutesFrom(__DIR__.'/../routes/web.php');
    }
}
