<?php

namespace FirstPoint\LunarSaferpay;

use Psr\Http\Message\ResponseInterface;

class SaferpayPaymentResponse
{
    protected array $data;

    public function __construct(ResponseInterface $response)
    {
        $this->data = json_decode($response->getBody(), true);
    }

    public function success(): bool
    {
        return isset($this->data['Token']);
    }

    public function message(): string
    {
        return $this->data['ErrorMessage'] ?? 'Success';
    }

    public function getRedirectUrl(): string
    {
        return $this->data['RedirectUrl'] ?? '';
    }

    public function getToken(): string
    {
        return $this->data['Token'] ?? '';
    }

    public function getTransactionId(): ?string
    {
        return $this->data['Transaction']['Id'] ?? null;
    }
}
