<?php

namespace FirstPoint\LunarSaferpay\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Lunar\Facades\Payments;
use Lunar\Models\Cart;

class SaferpayController extends Controller
{
    public function success(Request $request)
    {
        $cart = Cart::find($request->get('cart_id'));
        
        if (!$cart) {
            return redirect()->route('checkout.error')
                ->with('error', 'Cart not found');
        }

        $payment = Payments::driver('saferpay')->cart($cart);
        
        $response = $payment->authorize();
        
        if (!$response->success) {
            return redirect()->route('checkout.error')
                ->with('error', $response->message);
        }

        return redirect()->route('checkout.success');
    }

    public function cancel()
    {
        return redirect()->route('checkout.cart')
            ->with('error', 'Payment was cancelled');
    }
} 