<?php

namespace FirstPoint\LunarSaferpay\Components;

use Livewire\Component;
use Lunar\Facades\Payments;
use Lunar\Models\Cart;

class SaferpayPaymentButton extends Component
{
    public Cart $cart;
    
    public ?string $redirectUrl = null;
    
    public function mount(Cart $cart)
    {
        $this->cart = $cart;
    }
    
    public function initializePayment()
    {
        try {
            $paymentUrl = Payments::driver('saferpay')
                ->cart($this->cart)
                ->getPaymentUrl();

            if (!$paymentUrl) {
                $this->addError('payment', 'Unable to generate payment URL');
                return;
            }

            return redirect()->away($paymentUrl);
        } catch (\Exception $e) {
            $this->addError('payment', 'Failed to initialize payment: ' . $e->getMessage());
            return;
        }
    }
    
    public function render()
    {
        return view('lunar-saferpay::components.payment');
    }
} 