<div>
    @if(!$redirectUrl)
        <button 
            wire:click="initializePayment"
            wire:loading.attr="disabled"
            wire:loading.class="opacity-75 cursor-wait"
            class="flex justify-center items-center px-4 py-2.5 w-full text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-md shadow-sm transition duration-150 hover:border-gray-300 hover:shadow-md focus:outline-none focus:ring-2 focus:ring-gray-200 focus:ring-offset-1"
        >
            <span wire:loading.remove class="flex items-center">
                <svg class="w-4 h-4 mr-2 text-gray-600" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M3 10H21M7 15H8M12 15H13" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M19 14.5714V6C19 4.89543 18.1046 4 17 4H7C5.89543 4 5 4.89543 5 6V14.5714C5 15.5795 5 16.0836 5.17275 16.4693C5.37572 16.9002 5.71441 17.2389 6.14532 17.4419C6.53101 17.6146 7.03511 17.6146 8.04332 17.6146H15.9567C16.9649 17.6146 17.469 17.6146 17.8547 17.4419C18.2856 17.2389 18.6243 16.9002 18.8273 16.4693C19 16.0836 19 15.5795 19 14.5714Z" stroke="currentColor" stroke-width="2"/>
                </svg>
                {{ __('Payer avec SaferPay') }}
            </span>
            <span wire:loading class="flex items-center">
                <svg class="w-4 h-4 mr-2 text-gray-600 animate-spin" viewBox="0 0 24 24">
                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4" fill="none"></circle>
                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                </svg>
                {{ __('Chargement...') }}
            </span>
        </button>
    @endif
	
	@error('payment')
        <div class="mt-2 p-2.5 text-xs text-red-600 bg-red-50 rounded-md border border-red-100 flex items-center gap-2">
            <svg class="w-3.5 h-3.5 flex-shrink-0" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
            </svg>
            {{ $message }}
        </div>
    @enderror
</div> 