<?php

namespace FirstPoint\LunarPayrexx\Events;

use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Lunar\Models\Transaction;

class PayrexxPaymentFailed
{
    use Dispatchable, SerializesModels;

    /**
     * The transaction that failed.
     *
     * @var \Lunar\Models\Transaction
     */
    public $transaction;

    /**
     * The raw webhook data from Payrexx.
     *
     * @var array
     */
    public $webhookData;

    /**
     * The failure status from Payrexx.
     *
     * @var string
     */
    public $status;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(Transaction $transaction, array $webhookData, string $status)
    {
        $this->transaction = $transaction;
        $this->webhookData = $webhookData;
        $this->status = $status;
    }
}
