<?php

namespace FirstPoint\LunarPayrexx;

use Illuminate\Support\ServiceProvider;
use Lunar\Facades\Payments;

class PayrexxServiceProvider extends ServiceProvider
{
    public function boot()
    {
        // Register the payment driver
        Payments::extend('payrexx', function ($app) {
            return $app->make(PayrexxPaymentDriver::class);
        });

        // Load routes
        $this->loadRoutesFrom(__DIR__.'/../routes/web.php');

        // Load views
        $this->loadViewsFrom(__DIR__.'/../resources/views', 'lunar-payrexx');

        // Publish configuration
        $this->publishes([
            __DIR__.'/../config/lunar-payrexx.php' => config_path('lunar-payrexx.php'),
        ], 'lunar-payrexx-config');

        // Publish views
        $this->publishes([
            __DIR__.'/../resources/views' => resource_path('views/vendor/lunar-payrexx'),
        ], 'lunar-payrexx-views');
    }

    public function register()
    {
        $this->mergeConfigFrom(
            __DIR__.'/../config/lunar-payrexx.php',
            'lunar-payrexx'
        );

        // Register the redirect manager as singleton
        $this->app->singleton('lunar-payrexx-redirect-manager', function ($app) {
            return new PayrexxRedirectManager();
        });
    }
}
