<?php

namespace FirstPoint\LunarPayrexx\Events;

use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Lunar\Models\Order;
use Lunar\Models\Transaction;

class PayrexxOrderCreated
{
    use Dispatchable, SerializesModels;

    /**
     * The order that was created.
     *
     * @var \Lunar\Models\Order
     */
    public $order;

    /**
     * The transaction that created the order.
     *
     * @var \Lunar\Models\Transaction
     */
    public $transaction;

    /**
     * The raw webhook data from Payrexx.
     *
     * @var array
     */
    public $webhookData;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(Order $order, Transaction $transaction, array $webhookData)
    {
        $this->order = $order;
        $this->transaction = $transaction;
        $this->webhookData = $webhookData;
    }
}
