<?php

namespace FirstPoint\LunarPayrexx;

class PayrexxRedirectManager
{
    protected $successHandler = null;
    protected $failedHandler = null;
    protected $cancelHandler = null;

    /**
     * Set the success redirect handler
     */
    public function setSuccessRedirect(callable $handler): void
    {
        $this->successHandler = $handler;
    }

    /**
     * Set the failed redirect handler
     */
    public function setFailedRedirect(callable $handler): void
    {
        $this->failedHandler = $handler;
    }

    /**
     * Set the cancel redirect handler
     */
    public function setCancelRedirect(callable $handler): void
    {
        $this->cancelHandler = $handler;
    }

    /**
     * Get the success redirect URL
     */
    public function getSuccessRedirectUrl(string $reference): string
    {
        if ($this->successHandler) {
            return call_user_func($this->successHandler, $reference);
        }

        // Default fallback
        return route('payrexx.payment.success', ['ref' => $reference, '_locale' => app()->getLocale()]);
    }

    /**
     * Get the failed redirect URL
     */
    public function getFailedRedirectUrl(): string
    {
        if ($this->failedHandler) {
            return call_user_func($this->failedHandler);
        }

        // Default fallback
        return route('payrexx.payment.failed', ['_locale' => app()->getLocale()]);
    }

    /**
     * Get the cancel redirect URL
     */
    public function getCancelRedirectUrl(): string
    {
        if ($this->cancelHandler) {
            return call_user_func($this->cancelHandler);
        }

        // Default fallback
        return route('payrexx.payment.cancel', ['_locale' => app()->getLocale()]);
    }

    /**
     * Check if a handler is set for a specific type
     */
    public function hasHandler(string $type): bool
    {
        return match ($type) {
            'success' => $this->successHandler !== null,
            'failed' => $this->failedHandler !== null,
            'cancel' => $this->cancelHandler !== null,
            default => false,
        };
    }
}

