<?php

namespace FirstPoint\LunarPayrexx\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\View;
use Lunar\Facades\CartSession;

class PayrexxRedirectController
{
    /**
     * Handle successful payment redirect
     *
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function success(Request $request)
    {
        return $this->renderView('success', 'Payment initiated', 'Your payment is being processed. You will receive a confirmation once it is complete.');
    }

    /**
     * Handle failed payment redirect
     *
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function failed(Request $request)
    {
        return $this->renderView('error', 'Payment failed', 'Your payment could not be processed. Please try again or contact support.');
    }

    /**
     * Handle cancelled payment redirect
     *
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function cancel(Request $request)
    {
        return $this->renderView('error', 'Payment cancelled', 'Your payment was cancelled. No charges have been made to your account.');
    }

    /**
     * Render a view with the given type, title and message
     *
     * @param  string  $type  Either 'success' or 'error'
     * @param  string  $title  The title to display
     * @param  string  $message  The message to display
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    protected function renderView(string $type, string $title, string $message)
    {
        $viewData = [
            'title' => $title,
            'message' => $message,
        ];

        try {
            $viewName = $type === 'success' ? 'success' : 'error';

            if (View::exists("vendor.lunar-payrexx.payment.{$viewName}")) {
                return view("vendor.lunar-payrexx.payment.{$viewName}", $viewData);
            }

            if (View::exists("lunar-payrexx::payment.default-{$viewName}")) {
                return view("lunar-payrexx::payment.default-{$viewName}", $viewData);
            }

            return response()->view("lunar-payrexx::payment.simple-{$viewName}", $viewData);
        } catch (\Exception $e) {
            Log::error('Failed to render view', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);

            return response($message);
        }
    }
}
