<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Payrexx Configuration
    |--------------------------------------------------------------------------
    |
    | Here you can specify your Payrexx API key.
    |
    */
    'instance' => env('PAYREXX_INSTANCE', ''),
    'api_key' => env('PAYREXX_API_KEY', ''),

    /*
    |--------------------------------------------------------------------------
    | Test Mode
    |--------------------------------------------------------------------------
    |
    | This option controls whether the payment gateway is in test mode.
    | Set to true to use Payrexx's test environment.
    |
    */

    'test_mode' => env('PAYREXX_TEST_MODE', true),

    'order_statuses' => [
        'pending' => 'awaiting-payment',
        'success' => 'payment-received',
        'failed' => 'payment-failed',
    ],

    /*
    |--------------------------------------------------------------------------
    | Default Currency
    |--------------------------------------------------------------------------
    |
    | This is the default currency that will be used when none is specified.
    |
    */

    'currency' => env('PAYREXX_CURRENCY', 'CHF'),

    /*
    |--------------------------------------------------------------------------
    | Language Settings
    |--------------------------------------------------------------------------
    |
    | Configure language support for Payrexx payment pages.
    |
    | enable_language_support: Enable automatic language detection and URL modification
    | default_language: Default language code if none is detected (must be enabled in Payrexx)
    | supported_languages: Array of supported language codes (must be enabled in Payrexx account)
    |
    */

    'language' => [
        'enable_language_support' => env('PAYREXX_ENABLE_LANGUAGE_SUPPORT', true),
        'default_language' => env('PAYREXX_DEFAULT_LANGUAGE', 'en'),
        'supported_languages' => [
            'en', 'de', 'fr', 'it', 'es', 'pt', 'nl', 'pl', 'cs', 'sk', 'hu', 'ro', 'bg', 'hr', 'sl', 'lv', 'lt', 'et'
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Webhook Handler
    |--------------------------------------------------------------------------
    |
    | The webhook handler that will process Payrexx payment notifications.
    |
    */

    'webhook_handler' => \FirstPoint\LunarPayrexx\Http\Controllers\PayrexxWebhookController::class,
];
