<?php

namespace FirstPoint\LunarInvoice;

use FirstPoint\LunarInvoice\Components\InvoicePaymentButton;
use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;
use Lunar\Facades\Payments;

class InvoicePaymentServiceProvider extends ServiceProvider
{
    public function boot()
    {
        $this->loadViewsFrom(__DIR__.'/../resources/views', 'lunar-invoice');

        Livewire::component('invoice-payment-button', InvoicePaymentButton::class);

        Payments::extend('invoice', function ($app) {
            return $app->make(InvoicePaymentDriver::class);
        });
    }
} 