<?php

namespace FirstPoint\LunarInvoice;

use Lunar\Base\DataTransferObjects\PaymentAuthorize;
use Lunar\Base\DataTransferObjects\PaymentCapture;
use Lunar\Base\DataTransferObjects\PaymentRefund;
use Lunar\Events\PaymentAttemptEvent;
use Lunar\Models\Transaction;
use Lunar\PaymentTypes\AbstractPayment;

class InvoicePaymentDriver extends AbstractPayment
{
    public function authorize(): PaymentAuthorize
    {
		if (!$this->order) {
			if (!$this->order = $this->cart->order) {
				$this->order = $this->cart->createOrder();
			}
		}

		$response = new PaymentAuthorize(
			success: true,
			message: 'The payment was successful',
			orderId: $this->order->id,
			paymentType: 'invoice'
		);

		Transaction::create([
			'order_id' => $this->order->id,
			'type' => 'intent',
			'driver' => 'invoice',
			'amount' => $this->cart->total->value,
			'reference' => 'INV-' . $this->order->id,
			'status' => 'pending',
			'success' => true,
			'card_type' => 'invoice',
			'meta' => [
				'payment_method' => 'invoice',
			],
		]);
		
		PaymentAttemptEvent::dispatch($response);

		return $response;
    }

    public function capture(Transaction $transaction, $amount = 0): PaymentCapture
    {
		Transaction::create([
			'parent_transaction_id' => $transaction->id,
			'order_id' => $this->order->id,
			'type' => 'capture',
			'driver' => 'invoice',
			'amount' => $this->cart->total->value,
			'reference' => 'INV-' . $this->order->id,
			'status' => 'pending',
			'success' => true,
			'card_type' => 'invoice',
			'meta' => [
				'payment_method' => 'invoice',
			],
		]);

        return new PaymentCapture(
            success: true,
            message: 'Invoice payment captured'
        );
    }

    public function refund(Transaction $transaction, int $amount = 0, $notes = null): PaymentRefund
    {
        return new PaymentRefund(
            success: true,
            message: 'Invoice payment refunded'
        );
    }
}
