<?php

namespace FirstPoint\LunarInvoice\Components;

use Livewire\Component;
use Lunar\Facades\CartSession;
use Lunar\Facades\Payments;
use Lunar\Models\Cart;

class InvoicePaymentButton extends Component
{
    public Cart $cart;

    public function mount(Cart $cart)
    {
        $this->cart = $cart;
    }

    public function processPayment()
    {
        $response = Payments::driver('invoice')
            ->cart($this->cart)
            ->authorize();

		$this->cart->update([
			'completed_at' => now(),
		]);

		CartSession::forget();

		return redirect()->route('order-confirmation.show', ['order' => $response->orderId]);
    }

    public function render()
    {
        return view('lunar-invoice::components.payment-button');
    }
} 