# Lunar Invoice Payment Driver

A simple invoice payment driver for Lunar e-commerce platform that allows customers to place orders with pending payment status.

## Installation

You can install the package via composer:

```bash
composer require firstpoint-ch/lunar-invoice-driver
```

## Usage

1. Register the payment driver in your `config/lunar/payments.php`:

```php
return [
	'types' => [
		'invoice' => [
			'driver' => 'invoice',
		],
	],
];
```

2. Use the Livewire component in your checkout view:

```blade
<livewire:invoice-payment :cart="$cart" />
```

## Features

- Creates orders with pending payment status
- Simple invoice reference generation
- Livewire component for easy integration
- Automatic transaction creation

## License

The MIT License (MIT). Please see [License File](LICENSE.md) for more information.
