<?php

namespace FirstPoint\LunarHeylight;

use FirstPoint\LunarHeylight\Components\HeylightPaymentButton;
use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;
use Lunar\Facades\Payments;

class HeylightPaymentServiceProvider extends ServiceProvider
{
    public function register()
    {
        $this->mergeConfigFrom(__DIR__.'/../config/lunar-heylight.php', 'lunar-heylight');
    }

    public function boot()
    {
        // Register payment driver
        Payments::extend('heylight', function ($app) {
            return $app->make(HeylightPaymentDriver::class);
        });

        // Load routes
        $this->loadRoutesFrom(__DIR__.'/../routes/web.php');

        // Load views
        $this->loadViewsFrom(__DIR__.'/../resources/views', 'lunar-heylight');

        // Register Livewire components
        Livewire::component('heylight-payment-button', HeylightPaymentButton::class);

        if ($this->app->runningInConsole()) {
            $this->publishes([
                __DIR__.'/../config/lunar-heylight.php' => config_path('lunar-heylight.php'),
                __DIR__.'/../resources/views' => resource_path('views/vendor/lunar-heylight'),
                __DIR__.'/../resources/assets' => public_path('vendor/lunar-heylight'),
            ], 'lunar-heylight');
        }
    }
}
