<?php

namespace FirstPoint\LunarHeylight;

use Psr\Http\Message\ResponseInterface;

class HeylightPaymentResponse
{
    protected array $data;
    protected bool $successful;
    protected string $message;

    public function __construct(ResponseInterface $response)
    {
        $this->data = json_decode($response->getBody()->getContents(), true);
        $this->successful = $response->getStatusCode() === 201;
        $this->message = $this->successful ? 'Payment initialized successfully' : 'Failed to initialize payment';
    }

    public function success(): bool
    {
        return $this->successful;
    }

    public function message(): string
    {
        return $this->message;
    }

    public function getTransactionId(): ?string
    {
        return $this->data['external_contract_uuid'] ?? null;
    }

    public function getOrderId(): ?string
    {
        return $this->data['external_contract_uuid'] ?? null;
    }

    public function getPaymentUrl(): ?string
    {
        return $this->data['redirect_url'] ?? null;
    }
}
