<?php

namespace FirstPoint\LunarHeylight\Components;

use Livewire\Component;
use Lunar\Facades\Payments;
use Lunar\Models\Cart;

class HeylightPaymentButton extends Component
{
    public Cart $cart;
    public ?string $returnUrl = null;

    public function mount(Cart $cart, string $returnUrl = null)
    {
        $this->cart = $cart;
        $this->returnUrl = $returnUrl;
    }

    public function processHeylightPayment()
    {
        $paymentUrl = Payments::driver('heylight')
            ->cart($this->cart)
            ->getPaymentUrl();

        if ($paymentUrl) {
            return redirect()->away($paymentUrl);
        }

        $this->addError('payment', 'Failed to initialize payment');
    }

    public function render()
    {
        return view('lunar-heylight::components.payment');
    }
}
