<div class="w-full">
    <form wire:submit.prevent="processHeylightPayment">
        <button type="submit" 
                class="flex justify-center items-center px-4 py-2.5 w-full text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-md shadow-sm transition duration-150 hover:border-gray-300 hover:shadow-md focus:outline-none focus:ring-2 focus:ring-gray-200 focus:ring-offset-1"
                wire:loading.attr="disabled"
                wire:loading.class="opacity-75 cursor-wait">
            <span wire:loading.remove wire:target="processHeylightPayment" class="flex items-center">
                <svg class="w-4 h-4 mr-2 text-gray-600" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M17 9V7C17 4.23858 14.7614 2 12 2C9.23858 2 7 4.23858 7 7V9M12 14.5V16.5" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                    <path d="M5 9C3.89543 9 3 9.89543 3 11V19C3 20.1046 3.89543 21 5 21H19C20.1046 21 21 20.1046 21 19V11C21 9.89543 20.1046 9 19 9H5Z" stroke="currentColor" stroke-width="2"/>
                </svg>
                {{ __('Payer avec Heylight') }}
            </span>
            <span wire:loading wire:target="processHeylightPayment" class="flex items-center">
                <svg class="w-4 h-4 mr-2 text-gray-600 animate-spin" viewBox="0 0 24 24">
                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4" fill="none"></circle>
                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                </svg>
                {{ __('Chargement...') }}
            </span>
        </button>
    </form>

    @error('payment')
        <div class="mt-2 p-2.5 text-xs text-red-600 bg-red-50 rounded-md border border-red-100 flex items-center gap-2">
            <svg class="w-3.5 h-3.5 flex-shrink-0" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
            </svg>
            {{ $message }}
        </div>
    @enderror
</div> 