# Lunar Heylight Payment Driver

This package provides Heylight payment integration for LunarPHP.

## Installation

```bash
composer require firstpoint-ch/lunar-heylight-driver
```

## Configuration

1. Publish the configuration:
```bash
php artisan vendor:publish --tag="lunar-heylight-config"
```

2. Add your Heylight credentials to your .env file:

```
HEYLIGHT_API_KEY=your_api_key
HEYLIGHT_SECRET_KEY=your_secret_key
HEYLIGHT_SANDBOX=true
```

## Usage

In your checkout process:

```php
use Lunar\Facades\Payments;
$payment = Payments::driver('heylight')
->cart($cart)
->authorize();
if ($payment->success) {
// Payment successful
}
```

## Testing

```bash
composer test
```

## License

The MIT License (MIT). Please see [License File](LICENSE.md) for more information.