<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Connection Configuration
    |--------------------------------------------------------------------------
    |
    | Configure how to connect to your production environment:
    | - 'localhost': Connect directly to localhost (same server)
    | - 'ssh': Connect to a remote server via SSH
    |
    */
    'connection' => [
        'type' => env('PROD_CONNECTION_TYPE', 'ssh'), // 'ssh' or 'localhost'
    ],

    /*
    |--------------------------------------------------------------------------
    | Production SSH Configuration
    |--------------------------------------------------------------------------
    |
    | These settings define how to connect to your production server via SSH.
    | You can set these values in your .env file using the PROD_SSH_* keys.
    | Only used when connection.type is 'ssh'.
    |
    */
    'ssh' => [
        'username' => env('PROD_SSH_USERNAME'),
        'host' => env('PROD_SSH_HOST'),
        'port' => env('PROD_SSH_PORT', 22),
        'options' => [
            'ServerAliveInterval' => 60,
            'ServerAliveCountMax' => 3,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Production Database Configuration
    |--------------------------------------------------------------------------
    |
    | Configuration for connecting to your production database.
    |
    | For MySQL: The package will use mysqldump to export data.
    | For SQLite: The package will copy the database file directly using SCP.
    |
    */
    'database' => [
        // Database type: mysql, sqlite
        'type' => env('PROD_DB_TYPE', 'mysql'),

        // MySQL settings
        'host' => env('PROD_DB_HOST', '127.0.0.1'),
        'port' => env('PROD_DB_PORT', 3306),
        'database' => env('PROD_DB_DATABASE'),
        'username' => env('PROD_DB_USERNAME'),
        'password' => env('PROD_DB_PASSWORD'),

        // SQLite settings
        'sqlite' => [
            'remote_path' => env('PROD_SQLITE_PATH'), // e.g., '~/sites/example.com/database/database.sqlite'
        ],

        'dump_options' => [
            '--single-transaction',
            '--quick',
            '--compress',
            '--replace', // Use REPLACE INTO to avoid duplicate-key errors
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Storage Configuration
    |--------------------------------------------------------------------------
    |
    | Settings for syncing storage files from production to local.
    | Define multiple storage paths to sync different directories.
    |
    | Each path should have:
    | - 'name': A unique identifier for the path
    | - 'remote_path': The path on the production server (absolute path for localhost)
    | - 'local_path': The local path where files should be synced
    |
    | For localhost connections, use absolute paths for remote_path.
    | For SSH connections, use paths relative to the SSH user's home directory.
    |
    */
    'storage' => [
        'paths' => [
            [
                'name' => 'public',
                'remote_path' => env('PROD_STORAGE_PUBLIC_PATH', '~/sites/example.com/storage/app/public/'),
                'local_path' => 'storage/app/public/',
            ],
            // Add more paths as needed:
            // [
            //     'name' => 'uploads',
            //     'remote_path' => env('PROD_UPLOADS_PATH', '~/sites/example.com/uploads/'),
            //     'local_path' => 'public/uploads/',
            // ],
        ],

        'rsync_options' => [
            '-a', // archive mode
            '-h', // human-readable
            '-z', // compress
            '--delete', // remove local files that no longer exist remotely
            '--stats', // show summary
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Local Database Configuration
    |--------------------------------------------------------------------------
    |
    | Local database settings. By default, these will use your existing
    | Laravel database configuration from config/database.php.
    |
    */
    'local_database' => [
        'connection' => env('DB_CONNECTION', 'mysql'),
        'host' => env('DB_HOST', '127.0.0.1'),
        'port' => env('DB_PORT', 3306),
        'database' => env('DB_DATABASE'),
        'username' => env('DB_USERNAME'),
        'password' => env('DB_PASSWORD'),
    ],
];
