<?php

namespace FirstpointCh\LaravelPull\Commands;

use FirstpointCh\LaravelPull\LaravelPull;
use Illuminate\Console\Command;

class PullDatabaseCommand extends Command
{
    public $signature = 'pull:database {--force : Skip confirmation prompt}';

    public $description = 'Pull production database to local environment';

    public function handle(): int
    {
        $this->info('🗄️  Pulling production database...');
        $this->warn('⚠️  WARNING: This will REPLACE the data in your local database!');

        if (! $this->option('force') && ! $this->confirm('Do you want to continue?', false)) {
            $this->info('Operation cancelled.');

            return self::SUCCESS;
        }

        try {
            $laravelPull = app(LaravelPull::class);

            $laravelPull->setProgressCallback(function ($message) {
                $this->line("   → {$message}");
            });

            $laravelPull->pullDatabase();
            $this->info('✅ Database pull completed successfully.');

            return self::SUCCESS;
        } catch (\Exception $e) {
            $this->error("Database pull failed: {$e->getMessage()}");

            return self::FAILURE;
        }
    }
}
