<?php

namespace FirstpointCh\LaravelPull\Commands;

use FirstpointCh\LaravelPull\LaravelPull;
use Illuminate\Console\Command;

class LaravelPullCommand extends Command
{
    public $signature = 'pull';

    public $description = 'Pull all production data (database and storage) to local environment';

    public function handle(): int
    {
        $laravelPull = app(LaravelPull::class);

        try {
            $this->pullAll($laravelPull);

            return self::SUCCESS;
        } catch (\Exception $e) {
            $this->error("Pull operation failed: {$e->getMessage()}");

            return self::FAILURE;
        }
    }

    protected function pullDatabase(LaravelPull $laravelPull): void
    {
        $this->info('🗄️  Pulling production database...');
        $this->warn('⚠️  WARNING: This will REPLACE the data in your local database!');

        if (! $this->confirm('Do you want to continue?', false)) {
            $this->info('Operation cancelled.');

            return;
        }

        $laravelPull->setProgressCallback(function ($message) {
            $this->line("   → {$message}");
        });

        $laravelPull->pullDatabase();
        $this->info('✅ Database pull completed successfully.');
    }

    protected function pullStorage(LaravelPull $laravelPull): void
    {
        $this->info('📁 Pulling production storage files...');

        $laravelPull->setProgressCallback(function ($message) {
            $this->line("   → {$message}");
        });

        $laravelPull->pullStorage();
        $this->info('✅ Storage pull completed successfully.');
    }

    protected function pullAll(LaravelPull $laravelPull): void
    {
        $this->info('🚀 Pulling all production data (database + storage)...');
        $this->warn('⚠️  WARNING: This will REPLACE the data in your local database!');

        if (! $this->confirm('Do you want to continue?', false)) {
            $this->info('Operation cancelled.');

            return;
        }

        $laravelPull->setProgressCallback(function ($message) {
            $this->line("   → {$message}");
        });

        $laravelPull->pullAll();
        $this->info('✅ All data pulled successfully.');
    }
}
