<?php

namespace FirstpointCh\LaravelPull;

use FirstpointCh\LaravelPull\Commands\LaravelPullCommand;
use FirstpointCh\LaravelPull\Commands\PullDatabaseCommand;
use FirstpointCh\LaravelPull\Commands\PullStorageCommand;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class LaravelPullServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        $package
            ->name('laravel-pull')
            ->hasConfigFile('pull')
            ->hasCommands([
                LaravelPullCommand::class,
                PullDatabaseCommand::class,
                PullStorageCommand::class,
            ]);
    }

    public function packageRegistered(): void
    {
        $this->app->singleton(LaravelPull::class, function () {
            return new LaravelPull;
        });
    }
}
