<?php

namespace FirstpointCh\LaravelPull\Commands;

use FirstpointCh\LaravelPull\LaravelPull;
use Illuminate\Console\Command;

class PullStorageCommand extends Command
{
    public $signature = 'pull:storage {path? : Specific storage path name to pull}';

    public $description = 'Pull production storage files to local environment';

    public function handle(): int
    {
        $pathName = $this->argument('path');

        if ($pathName) {
            $this->info("📁 Pulling production storage path '{$pathName}'...");
        } else {
            $this->info('📁 Pulling production storage files...');
        }

        try {
            $laravelPull = app(LaravelPull::class);

            $laravelPull->setProgressCallback(function ($message) {
                $this->line("   → {$message}");
            });

            $laravelPull->pullStorage($pathName);
            $this->info('✅ Storage pull completed successfully.');

            return self::SUCCESS;
        } catch (\Exception $e) {
            $this->error("Storage pull failed: {$e->getMessage()}");

            return self::FAILURE;
        }
    }
}
