<?php

namespace Firstpoint\GlideHelper;

use Spatie\Glide\GlideImage;

class GlideHelper
{
    private string $publicPath;

    public function __construct()
    {
        $this->publicPath = config('glide-helper.public_path');
    }

    private function startsWith(string $haystack, string $needle): bool
    {
        return strncmp($haystack, $needle, strlen($needle)) === 0;
    }

    private function after(string $subject, string $search): string
    {
        if ($search === '') {
            return $subject;
        }

        $pos = strpos($subject, $search);
        if ($pos === false) {
            return $subject;
        }

        return substr($subject, $pos + strlen($search));
    }

    public function generateGlideUrl(?string $path = null, ?array $modifications = [], ?bool $defer = null): ?string
    {
        $defer = $defer !== null ? $defer : config('glide-helper.defer_generation');

        if (empty($path)) {
            return null;
        }

        if ($this->startsWith($path, 'http')) {
            $path = $this->after($path, url('/'));
        }

        $path = ltrim($path, '/');
        ksort($modifications);

        $pathInfo = pathinfo($path);
        $extension = $modifications['fm'] ?? $pathInfo['extension'];
        $key = md5($path.serialize($modifications));

        $storagePath = config('glide-helper.storage_path', 'glide');
        $dirname = $pathInfo['dirname'] === '.' ? '' : $pathInfo['dirname'].'/';
        $outputPath = sprintf('%s/%s%s-%s.%s', $storagePath, $dirname, $pathInfo['filename'], $key, $extension);

        $fullPath = $this->publicPath.'/'.$outputPath;

        if (! is_dir($this->publicPath.'/'.$path) && file_exists($this->publicPath.'/'.$path)) {
            if (! file_exists($fullPath)) {
                $processImage = function () use ($path, $fullPath, $modifications) {
                    @mkdir(dirname($fullPath), 0755, true);
                    GlideImage::create($this->publicPath.'/'.$path)->modify($modifications)->save($fullPath);
                };

                if ($defer) {
                    defer($processImage);
                } else {
                    $processImage();

                    return asset($outputPath);
                }
            } else {
                return asset($outputPath);
            }
        }

        return asset($path);
    }
}
