# Glide Helper

[![Latest Version on Packagist](https://img.shields.io/packagist/v/firstpoint-ch/glide-helper.svg?style=flat-square)](https://packagist.org/packages/firstpoint-ch/glide-helper)
[![GitHub Tests Action Status](https://img.shields.io/github/actions/workflow/status/firstpoint-ch/glide-helper/run-tests.yml?branch=main&label=tests&style=flat-square)](https://github.com/firstpoint-ch/glide-helper/actions?query=workflow%3Arun-tests+branch%3Amain)
[![GitHub Code Style Action Status](https://img.shields.io/github/actions/workflow/status/firstpoint-ch/glide-helper/fix-php-code-style-issues.yml?branch=main&label=code%20style&style=flat-square)](https://github.com/firstpoint-ch/glide-helper/actions?query=workflow%3A"Fix+PHP+code+style+issues"+branch%3Amain)
[![Total Downloads](https://img.shields.io/packagist/dt/firstpoint-ch/glide-helper.svg?style=flat-square)](https://packagist.org/packages/firstpoint-ch/glide-helper)

A Laravel package that provides a simple helper function for image manipulation using Glide. Generate image URLs with on-the-fly transformations like resizing, format conversion, and quality adjustments, with support for deferred processing.

## Installation

You can install the package via composer:

```bash
composer require firstpoint-ch/glide-helper
```

You can publish the config file with:

```bash
php artisan vendor:publish --tag="glide-helper-config"
```

This is the contents of the published config file:

```php
return [
    /*
    |--------------------------------------------------------------------------
    | Glide Storage Path
    |--------------------------------------------------------------------------
    |
    | This value determines the path where Glide will store the processed images.
    | The path is relative to the public directory.
    |
    */
    'storage_path' => 'glide',

    /*
    |--------------------------------------------------------------------------
    | Defer Image Generation
    |--------------------------------------------------------------------------
    |
    | When set to true, image processing will be deferred to a background process.
    | When false, images will be processed immediately during the request.
    |
    */
    'defer_generation' => true,
];
```

## Usage

```html
<img src="{{ glide('path', ['w' => 50, 'h' => 50, 'fm' => 'webp', 'q' => 100, 'dpr' => 1.5]) }}" />
```

### Deferred Processing

By default, image processing is deferred to a background process to improve response times. When deferred, the first user that loads the page will see the original images while the processing happens in the background. You can disable deferred processing by setting `defer_generation` to `false` in the config or by passing `false` as the third parameter to the glide helper function:

```html
<img src="{{ glide('path', ['w' => 50, 'h' => 50, 'fm' => 'webp', 'q' => 100, 'dpr' => 1.5], defer: false) }}" />
```

## Testing

```bash
composer test
```

## Changelog

Please see [CHANGELOG](CHANGELOG.md) for more information on what has changed recently.

## Contributing

Please see [CONTRIBUTING](CONTRIBUTING.md) for details.

## Security Vulnerabilities

Please review [our security policy](../../security/policy) on how to report security vulnerabilities.

## Credits

- [fredmarmillod](https://github.com/fredmarmillod)
- [All Contributors](../../contributors)

## License

The MIT License (MIT). Please see [License File](LICENSE.md) for more information.
