<?php

use Firstpoint\GlideHelper\GlideHelper;

if (! function_exists('glide')) {
    /**
     * Generate a URL for an image processed with Glide modifications. The image will be
     * processed on-the-fly with the specified transformations.
     *
     * @param  string|null  $path  Path to the source image file
     * @param  array|null  $modifications  Array of Glide image modifications
     *                                     Supported modifications:
     *                                     - w: Width
     *                                     - h: Height
     *                                     - fm: Format (jpg, png, webp, etc)
     *                                     - q: Quality (0-100)
     *                                     - dpr: Device pixel ratio
     * @param  bool  $defer  Whether to defer image processing
     * @return string|null URL to the processed image or null if path is empty or not found
     */
    function glide(?string $path = null, ?array $modifications = [], ?bool $defer = null): ?string
    {
        return (new GlideHelper)->generateGlideUrl($path, $modifications, $defer);
    }
}
