---
title: Configuration
---
Models can be translated in two different ways:

1. **Database:** It stores translations as JSON in the database
2. **Dictonary:** It stores keys and retrieve translations from the global ```/resources/lang/[locale].json``` or any specific file in ```/resources/lang/[locale]/[dictonary].php```.

First you should store any database translated field as a ```json``` column. This package provide a ```translatable``` macro so you can quickly see which fields are translatable. Fields using the dictonary mode could be set to ```string```.

```php
Schema::create('products', function ($table) {
    $table->id();
    $table->translatable('name'); // Outputs $table->json('name');
    $table->string('category'); // Will be used as a dictonary
    $table->decimal('price');
    $table->timestamps();
})
```

Then you should add the ```Translatable``` trait to the model and cast attributes using ```Localized```or ```Dictonary```

```php
use FirstpointCh\Translatable\Casts\Dictonary;
use FirstpointCh\Translatable\Casts\Localized;
use FirstpointCh\Translatable\Traits\Translatable;

class Product extends Model
{
    use Translatable;

    protected $casts = [
        // Database
        'name' => Localized::class,

        // Dictonary: get value from /resources/lang/[locale].json
        'category' => Dictonary::class,
    ];
}
```

You can specify the dictonary by appending the name as a parameter.

```php
class Product extends Model
{
    protected $casts = [
        // Will get value from /resources/lang/[locale]/categories.php
        'category' => Dictonary::class.':categories',
    ];
}
```
