---
title: Usage
---
Once your model is properly configured, translated attributes work like any other attribute. Basic operations will always run in the current locale unless you specify another one.

## Getting translations

Get an attribute in the curent locale or fallback to the default locale:

```php
echo $product->name;
```

You can force a specific locale with ```->in($locale)```. If the translation doesn't exist, it will not fallback. ```in()``` also changes the default locale on the model.

```php
// Output the name in french or null, no fallback.
echo $product->in('fr')->name;
echo $product->description; // Still in french
```

To get raw values, use ```->raw('attribute')```. You can also set the default locale to ```*``` to disable localization:

```php
echo $product->raw('name'); // ['en' => 'name']
dd($product->description); // "The description"

echo $product->in('*')->name; // ['en' => 'name']
dd($product->description); // ['en' => 'The description']
```

### Using arrays

```php
$product->toArray();

// Output
[
    'id' => 1,
    'name' => 'Product name',
    // ...
]

$product->in('fr')->toArray();

// Output
[
    'id' => 1,
    'name' => 'Nom du produit',
    // ...
]

$product->in('*')->toArray();

// Output
[
    'id' => 1,
    'name' => ['en' => 'Product name', 'fr' => 'Nom du produit'],
    // ...
]
```

## Creating entries

By default, entries are created in the current locale:

```php
Product::create([
    'name' => 'Product name',
]);
```

You can set multiple translations at once:

```php
Product::create([
    'name' => [
        'en' => 'Product name',
        'fr' => 'Nom du produit',
    ],
    'description' => 'Description ...', // description will be set in the current locale only
]);

// Using arrow notation
Product::create([
    'name->en' => 'Product name',
    'name->fr' => 'Nom du produit',
    'description' => 'Description ...',
]);
```

## Updating

Updating an entry in the current locale

```php
$product->update([
    'name' => 'test'
]);
```

You can specify a locale for the update

```php
// Update translation for a specific locale
$product->in('fr')->update([
    'name' => 'test'
]);
```

Or set multiple locales at once

```php
// Using arrow notation
$product->update([
    'name->en' => 'Product name',
    'name->fr' => 'Nom du produit',
]);
```

When passing an array, the value gets overridden

```php
// Override all translations using an array
$product->update([
    'name' => [
        'en' => 'Product name',
        'fr' => 'Nom du produit',
    ],
]);
```
