---
title: Configuration
---
Models can be translated in two ways:

1. **Database:** Stores translations as JSON in the database
2. **Dictionary:** Stores keys and retrieves translations from global ```/resources/lang/[locale].json``` or any specific file in ```/resources/lang/[locale]/[dictionary].php```.

First you should store any database translated field as a ```json``` column. This package provides a ```translatable``` macro so you can quickly see which fields are translatable. Fields using the dictionary mode can be set to ```string```.

```php
Schema::create('products', function ($table) {
    $table->id();
    $table->translatable('name'); // Outputs $table->json('name');
    $table->string('category'); // Will use the dictionary mode
    $table->decimal('price');
    $table->timestamps();
})
```

Then you can add the ```Translatable``` trait to the model and cast attributes using ```Localized```or ```Dictionary```

```php
use FirstpointCh\Translatable\Casts\Dictionary;
use FirstpointCh\Translatable\Casts\Localized;
use FirstpointCh\Translatable\Traits\Translatable;

class Product extends Model
{
    use Translatable;

    protected $casts = [
        // Database
        'name' => Localized::class,

        // Dictionary: get value from /resources/lang/[locale].json
        'category' => Dictionary::class,
    ];
}
```

You can specify the dictionary by appending the name as a parameter.

```php
class Product extends Model
{
    protected $casts = [
        // Will get value from /resources/lang/[locale]/categories.php
        'category' => Dictionary::class.':categories',
    ];
}
```
