<?php

namespace FirstpointCh\Cream\Http\Livewire\Views;

use Livewire\Component;

abstract class EditForm extends Component
{
    public $title = '';

    public $formData = [];

    public $rules = [];

    public $belongsTo = [];

    public function fields()
    {
        return [];
    }

    public function initializeForm($data)
    {
        foreach ($this->fields() as $field) {
            $this->formData[$field->property] = $field->getValue($data->{$field->property});

            $this->rules['formData.' . $field->property] = $field->rules ?? 'nullable';

            if ($field instanceof \FirstpointCh\Cream\View\Components\Form\BelongsTo) {
                $model = $field->find($this->formData[$field->property]);

                $this->belongsTo[$field->property] = [
                    'label' => optional($model)->{$field->labelField},
                    'value' => '',
                ];
            }
        }
    }

    public function render()
    {
        return view('cream::livewire.views.create-form')
            ->layout('cream::layouts.app');
    }

    public function submit()
    {
        $this->save(
            $this->validate()['formData']
        );
    }

    public function updateBelongsTo($property, $label, $value)
    {
        $this->formData[$property] = $value;
        $this->belongsTo[$property]['label'] = $label;
        $this->belongsTo[$property]['value'] = null;
    }
}
