<?php

namespace FirstpointCh\Cream;

use FirstpointCh\Cream\Commands\MakeField;
use FirstpointCh\Cream\Commands\MakeView;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;

class CreamServiceProvider extends ServiceProvider
{
    public function register()
    {
        $this->app->instance(\FirstpointCh\Cream\Cream::class, new \FirstpointCh\Cream\Cream);
    }

    public function boot()
    {
        $this->views();
        $this->config();
        $this->bladeComponents();
        $this->livewireComponents();
        $this->registerCommands();
        $this->routes();
        $this->publishAssets();
    }

    public function views()
    {
        $this->loadViewsFrom(__DIR__.'/../resources/views', 'cream');
    }

    public function config()
    {
        $this->publishes([
            __DIR__.'/../config/cream.php' => config_path('cream.php'),
        ]);
    }

    public function bladeComponents()
    {
        Blade::componentNamespace('FirstpointCh\\Cream\\View\\Components', 'cream');
    }

    public function livewireComponents()
    {
        Livewire::component('create-form', \FirstpointCh\Cream\Http\Livewire\Views\CreateForm::class);
        Livewire::component('edit-form', \FirstpointCh\Cream\Http\Livewire\Views\EditForm::class);
        Livewire::component('index-view', \FirstpointCh\Cream\Http\Livewire\Views\IndexView::class);
    }

    public function registerCommands()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                MakeView::class,
                MakeField::class,
            ]);
        }
    }

    public function routes()
    {
        $this->loadRoutesFrom(__DIR__.'/../routes/auth.php');
    }

    public function publishAssets()
    {
        $this->publishes([
            __DIR__.'/../dist' => public_path('vendor/cream'),
        ], 'public');
    }
}
