<?php

namespace FirstpointCh\Cream;

class Column
{
    public $title;
    public $property;
    public $callback;
    public $options;
    public $sortable;
    public $asHTML;

    public function __construct($title, $property = null, $callback = null)
    {
        $this->title = $title;
        $this->property = $property;
        $this->callback = $callback;
    }

    public static function make($title, $property = null, $callback = null)
    {
        return new self($title, $property, $callback);
    }

    public function render($model)
    {
        if (is_callable($this->callback)) {
            return ($this->callback)($model);
        }

        return $model->{$this->property};
    }

    public function sortable($sortable = true)
    {
        $this->sortable = $sortable;

        return $this;
    }

    public function asHTML($asHTML = true)
    {
        $this->asHTML = $asHTML;

        return $this;
    }
}
