<div>
    @if ($displayHeader)
        <x-cream::header :title="$title">
            @foreach ($this->heading() as $item)
                {!! $item->render()->with($item->data()) !!}
            @endforeach
        </x-cream::header>
    @endif

    <div>
        <div class="flex">
            @if (!empty($this->searchable))
                <div class="relative rounded-md shadow-sm max-w-xs">
                    <input
                        type="text"
                        wire:model="searchQuery"
                        class="focus:ring-blue-500 focus:border-blue-500 block w-full pr-10 sm:text-sm border-gray-300 rounded-md"
                        placeholder="Rechercher"
                    />

                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                        <svg class="w-5 h-5 text-gray-400" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                </div>
            @endif

            @if ($filters = collect($this->filters())->filter(function ($filter) {
                return !$filter->displayInline;
            })->toArray())
                <div class="ml-4 mr-auto">
                    <div x-data="{ open: false }" class="relative inline-block text-left" x-on:click.away="open = false">
                        <div x-on:click="open = !open">
                            <button type="button" class="inline-flex justify-center w-full rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-100 focus:ring-blue-500" id="options-menu" aria-expanded="true" aria-haspopup="true">
                                Filtres

                                <svg class="-mr-1 ml-2 h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                </svg>
                            </button>
                        </div>

                        <div
                            x-show="open"
                            x-transition:enter="transition ease-out duration-100"
                            x-transition:enter-start="transform opacity-0 scale-95"
                            x-transition:enter-end="transform opacity-100 scale-100"
                            x-transition:leave="transition ease-in duration-75"
                            x-transition:leave-start="transform opacity-100 scale-100"
                            x-transition:leave-end="transform opacity-0 scale-95"
                            class="origin-top-right absolute right-0 mt-2 w-56 rounded-md shadow-lg bg-white ring-1 ring-black ring-opacity-5 divide-y divide-gray-100 focus:outline-none overflow-hidden"
                            role="menu"
                            aria-orientation="vertical"
                            aria-labelledby="options-menu"
                        >
                            @foreach ($filters as $filter)
                                @include($filter->view())
                            @endforeach
                        </div>
                    </div>
                </div>
            @endif

            @if ($filters = collect($this->filters())->filter(function ($filter) {
                return $filter->displayInline;
            })->toArray())
                @foreach ($filters as $filter)
                    @include($filter->view())
                @endforeach
            @endif

            @if (!$displayHeader)
                <div class="ml-auto">
                    @foreach ($this->heading() as $item)
                        <div wire:key="heading-{{ $loop->index }}">{!! $item->render()->with($item->data()) !!}</div>
                    @endforeach
                </div>
            @endif
        </div>

        <div class="flex flex-col mt-4">
            <div class="align-middle min-w-full">
                <div class="shadow overflow-hidden border-b border-gray-200 sm:rounded-lg">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                @foreach ($columns as $column)
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider {{ $column->sortable ? 'cursor-pointer' : '' }}" @if ($column->sortable)wire:click="changeSortBy('{{ $column->property }}')"@endif>
                                        <div class="flex items-center">
                                            <span>{{ $column->title }}</span>

                                            @if ($column->sortable && $sortBy === $column->property)
                                                @if ($sortDirection === 'ASC')
                                                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M14.707 12.707a1 1 0 01-1.414 0L10 9.414l-3.293 3.293a1 1 0 01-1.414-1.414l4-4a1 1 0 011.414 0l4 4a1 1 0 010 1.414z" clip-rule="evenodd"></path></svg>
                                                @else
                                                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path></svg>
                                                @endif
                                            @endif
                                        </div>
                                    </th>
                                @endforeach

                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>

                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach ($models as $model)
                                <tr>
                                    @foreach ($columns as $column)
                                        <td class="px-6 py-4 whitespace-no-wrap text-sm leading-5 text-gray-500">
                                            @if ($column->asHTML)
                                                {!! $column->render($model) !!}
                                            @else
                                                {{ $column->render($model) }}
                                            @endif
                                        </td>
                                    @endforeach

                                    <td class="text-right pr-4 whitespace-no-wrap">
                                        @foreach ($_instance->actions($model) as $action)
                                            <a href="{{ $action->href }}" type="button" class="inline-flex items-center p-1.5 text-gray-300 hover:text-blue-500">
                                                {!! $action->icon !!}
                                            </a>
                                        @endforeach

                                        @if (auth()->user()->can('view', $model) && $model->getViewPath())
                                            <a href="{{ $model->getViewPath() }}" type="button" class="inline-flex items-center p-1.5 text-gray-300 hover:text-blue-500">
                                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                                </svg>
                                            </a>
                                        @endif

                                        @if (auth()->user()->can('update', $model) && $model->getEditPath())
                                            <a href="{{ $model->getEditPath() }}" type="button" class="inline-flex items-center p-1.5 text-gray-300 hover:text-blue-500">
                                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                                </svg>
                                            </a>
                                        @endif

                                        @if (auth()->user()->can('delete', $model) && $model->getDeletePath())
                                            <form action="{{ $model->getDeletePath() }}" class="inline-flex items-center p-1.5 text-gray-300 hover:text-red-500" method="POST" onsubmit="return confirm('Confirmer la suppression ?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit">
                                                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                                    </svg>
                                                </button>
                                            </form>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                {{-- {{ $models->links('canvas::partials.pagination') }} --}}
            </div>
        </div>
    </div>
</div>
