<?php

namespace FirstpointCh\Cream\View\Components\Form;

use FirstpointCh\Cream\AbstractField;

class BelongsTo extends AbstractField
{
    public $_model;

    public $labelField;

    public $valueField;

    public $searchColumns;

    public function model($model, $labelField, $valueField = 'id')
    {
        $this->_model = $model;
        $this->labelField = $labelField;
        $this->valueField = $valueField;

        return $this;
    }

    public function query($search = null)
    {
        if (empty($this->searchColumns) || empty($search)) {
            return $this->_model::all();
        }

        return $this->_model::query()->where(function ($query) use ($search) {
            foreach ($this->searchColumns as $column) {
                $query->orWhere($column, 'like', '%' . $search . '%');
            }
        })->get();
    }

    public function find($value)
    {
        return $this->_model::find($value);
    }

    public function searchable($searchColumns)
    {
        $this->searchColumns = $searchColumns;

        return $this;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        return view('cream::components.form.belongs-to', $this->data());
    }
}
