<?php

namespace FirstpointCh\Cream\Http\Livewire\Views;

use Livewire\Component;
use Illuminate\Support\Str;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

abstract class CreateForm extends Component
{
    use AuthorizesRequests;

    public $title = '';

    public $formData = [];

    public $rules = [];

    public $belongsTo = [];

    public function fields()
    {
        return [];
    }

    public function initializeForm()
    {
        foreach ($this->fields() as $field) {
            $this->formData[$field->property] = $field->getValue($field->defaultValue);

            $this->rules['formData.' . $field->property] = $field->rules ?? 'nullable';

            if ($field instanceof \FirstpointCh\Cream\View\Components\Form\BelongsTo) {
                $this->belongsTo[$field->property] = [
                    'label' => '',
                    'value' => '',
                ];
            }
        }
    }

    public function render()
    {
        return view('cream::livewire.views.create-form')
            ->layout('cream::layouts.app');
    }

    public function submit()
    {
        $this->save(
            $this->validate()['formData']
        );
    }

    public function updateBelongsTo($property, $label, $value)
    {
        $this->formData[$property] = $value;
        $this->belongsTo[$property]['label'] = $label;
        $this->belongsTo[$property]['value'] = null;

        $updatedMethod = 'updatedFormData' . Str::studly($property);

        if (method_exists($this, $updatedMethod)) {
            $this->$updatedMethod($value);
        }
    }
}
