<?php

namespace FirstpointCh\Cream\Filters;

use ReflectionClass;
use Illuminate\Support\Str;

abstract class Filter
{
    public $handler;

    /**
     * if true, this filter will be applied even with null value
     *
     * @var boolean
     */
    public $allowNull = false;

    public $displayInline = false;

    public static function make(...$args)
    {
        return new static(...$args);
    }

    public function view()
    {
        $class = new ReflectionClass($this);

        return 'cream::filters.' . Str::slug(Str::snake($class->getShortName()));
    }

    public function handle(callable $handler)
    {
        $this->handler = $handler;

        return $this;
    }

    public function getValue($value = null)
    {
        return $value;
    }

    public function inline($inline = true)
    {
        $this->displayInline = $inline;

        return $this;
    }
}
