<?php

namespace FirstpointCh\Cream\Commands;

use Illuminate\Support\Str;
use Illuminate\Support\Facades\File;
use Illuminate\Console\GeneratorCommand;
use Symfony\Component\Console\Input\InputArgument;

class MakeField extends GeneratorCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'cream:field {name}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Replace the class name for the given stub.
     *
     * @param  string  $stub
     * @param  string  $name
     * @return string
     */
    protected function replaceClass($stub, $name)
    {
        $stub = parent::replaceClass($stub, $name);

        $content = str_replace('{{ class }}', $this->argument('name'), $stub);
        $content = str_replace('{{ view }}', Str::kebab($this->argument('name')), $content);

        return $content;
    }

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getStub()
    {
        $path = __DIR__ . '/../../stubs/form/field.stub';

        return  $path;
    }

    /**
     * Get the default namespace for the class.
     *
     * @param  string  $rootNamespace
     * @return string
     */
    protected function getDefaultNamespace($rootNamespace)
    {
        return $rootNamespace . '\\View\\Components\\Form';
    }

    /**
     * Get the console command arguments.
     *
     * @return array
     */
    protected function getArguments()
    {
        return [
            ['name', InputArgument::REQUIRED, 'The name of the field.'],
        ];
    }

    public function handle()
    {
        parent::handle();

        File::makeDirectory(resource_path('views/components/cream/form'), 0755, true);

        File::copy(
            __DIR__ . '/../../stubs/form/field.blade.stub',
            resource_path('views/components/cream/form/' . Str::kebab($this->argument('name')) . '.blade.php')
        );
    }
}
