<div class="px-8 py-4 border-b">
    <div class="flex flex-wrap -mx-4">
        <label for="{{ $property }}" class="pt-2 block w-full md:max-w-sm text-sm font-medium text-gray-700">
            {{ $title }}
        </label>

        <div class="flex-1">
            <div x-data="{ active: @entangle('formData.' . $property) }">
                <button
                    type="button"
                    class="flex-shrink-0 group relative rounded-full inline-flex items-center justify-center h-5 w-10 cursor-pointer focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500"
                    role="switch"
                    aria-checked="false"
                    x-on:click="active = !active"
                >
                    <span class="sr-only">Use setting</span>

                    <span aria-hidden="true" class="pointer-events-none absolute bg-white w-full h-full rounded-md"></span>

                    <span
                        aria-hidden="true"
                        class="pointer-events-none absolute h-4 w-9 mx-auto rounded-full transition-colors ease-in-out duration-200"
                        :class="active ? 'bg-blue-600' : 'bg-gray-200'"
                    ></span>

                    <span
                        aria-hidden="true"
                        class="pointer-events-none absolute left-0 inline-block h-5 w-5 border border-gray-200 rounded-full bg-white shadow transform ring-0 transition-transform ease-in-out duration-200"
                        :class="active ? 'translate-x-5' : 'translate-x-0'"
                    ></span>
                </button>
            </div>
        </div>
    </div>
</div>

