<div class="px-8 py-4 border-b">
    <div class="flex flex-wrap -mx-4">
        <label for="{{ $property }}" class="pt-2 block w-full md:max-w-sm text-sm font-medium text-gray-700">
            {{ $title }}
        </label>

        <div class="flex-1">
            @if (empty($searchColumns))
                <select
                    type="text"
                    name="{{ $property }}"
                    id="{{ $property }}"
                    class="shadow-sm focus:ring-blue-500 focus:border-blue-500 block w-full sm:max-w-xs sm:text-sm border-gray-300 rounded-md"
                    wire:model="formData.{{ $property }}"
                >
                    <option value="">-</option>

                    @foreach ($query() as $item)
                        <option value="{{ $item->{$valueField} }}">{{ $item->{$labelField} }}</option>
                    @endforeach
                </select>
            @else
                <div
                    x-data="{ open: false }"
                    class="mt-1 relative sm:max-w-xs"
                    x-on:click.away="open = false"
                >
                    <button
                        type="button"
                        class="bg-white relative w-full border border-gray-300 rounded-md shadow-sm pl-3 pr-10 py-2 text-left cursor-default focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                        aria-haspopup="listbox"
                        aria-expanded="true"
                        x-on:click="open = !open"
                    >
                        <span class="block truncate">
                            {{ $_instance->belongsTo[$property]['label'] }}&nbsp;
                        </span>

                        <span class="absolute inset-y-0 right-0 flex items-center pr-2 pointer-events-none">
                            <!-- Heroicon name: solid/selector -->
                            <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                <path fill-rule="evenodd" d="M10 3a1 1 0 01.707.293l3 3a1 1 0 01-1.414 1.414L10 5.414 7.707 7.707a1 1 0 01-1.414-1.414l3-3A1 1 0 0110 3zm-3.707 9.293a1 1 0 011.414 0L10 14.586l2.293-2.293a1 1 0 011.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </span>
                    </button>

                    <ul
                        x-show="open"
                        class="absolute z-20 mt-1 w-full bg-white shadow-lg max-h-60 rounded-md py-1 text-base ring-1 ring-black ring-opacity-5 overflow-auto focus:outline-none sm:text-sm"
                        tabindex="-1"
                        role="listbox"
                    >
                        <li class="text-gray-900 cursor-default select-none relative py-2 pl-3 pr-3" id="listbox-option-0" role="option">
                            <input type="text" class="block w-full shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm border-gray-300 rounded-md" placeholder="Rechercher ..." wire:model.debounce.150ms="belongsTo.{{ $property }}.value">
                        </li>

                        @foreach ($query($_instance->belongsTo[$property]['value']) as $item)
                            <li
                                wire:key="{{ 'belongsTo-' . $property . '-' . $item->{$valueField} }}"
                                class="{{ $_instance->formData[$property] == $item->{$valueField} ? 'text-white bg-blue-600' : 'text-gray-900' }} cursor-default select-none relative py-2 pl-3 pr-9"
                                role="option"
                                @if ($_instance->formData[$property] == $item->{$valueField})
                                    x-on:click="open = false"
                                    wire:click="updateBelongsTo('{{ $property }}', null, null)"
                                @else
                                    x-on:click="open = false"
                                    wire:click="updateBelongsTo('{{ $property }}', '{{ $item->{$labelField} }}', '{{ $item->{$valueField} }}')"
                                @endif
                            >
                                <span class="{{ $_instance->formData[$property] == $item->{$valueField} ? 'font-semibold' : 'font-normal' }} block truncate">
                                    {{ $item->{$labelField} }}
                                </span>

                                @if ($_instance->formData[$property] == $item->{$valueField})
                                    <span class="text-white absolute inset-y-0 right-0 flex items-center pr-4">
                                        <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
                                        </svg>
                                    </span>
                                @endif
                            </li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @error('formData.' . $property)
                <div class="text-sm text-red-500">{{ $message }}</div>
            @enderror
        </div>
    </div>
</div>
