<?php

namespace FirstpointCh\Cream;

class Column
{
    public $title;
    public $property;
    public $options;
    public $sortable;
    public $asHTML;
    public $callback;
    public $secondLine;
    public $link;

    public function __construct($title, $property = null)
    {
        $this->title = $title;
        $this->property = $property;
    }

    public static function make($title, $property = null)
    {
        return new static($title, $property);
    }

    public static function date($title, $property = null)
    {
        return new DateColumn($title, $property);
    }

    public function render($model)
    {
        if (is_callable($model)) {
            $this->callback = $model;

            return $this;
        }

        if (is_callable($this->callback)) {
            return ($this->callback)($model);
        }

        return $model->{$this->property};
    }

    public function sortable($sortable = null)
    {
        $this->sortable = $sortable ?? $this->property;

        return $this;
    }

    public function asHTML($asHTML = true)
    {
        $this->asHTML = $asHTML;

        return $this;
    }

    public function secondLine($secondLine)
    {
        $this->secondLine = $secondLine;

        return $this;
    }

    public function link($link)
    {
        $this->link = $link;
    }
}
