<?php

namespace FirstpointCh\Cream\Http\Livewire\Views;

use Livewire\Component;
use Illuminate\Support\Str;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

abstract class CreateForm extends Component
{
    use AuthorizesRequests;

    public $title = '';

    public $formData = [];

    public $rules = [];

    public $belongsTo = [];

    public function fields()
    {
        return [];
    }

    public function initializeForm($data = null)
    {
        foreach ($this->fields() as $field) {
            $this->rules['formData.' . $field->property] = $field->rules ?? 'nullable';

            $this->formData[$field->property] = $field->getValue($field->defaultValue);

            if ($field instanceof \FirstpointCh\Cream\View\Components\Form\BelongsTo) {
                $this->belongsTo[$field->property] = [
                    'label' => '',
                    'value' => '',
                ];
            }
        }

        if (!empty($data)) {
            foreach ($this->fields() as $field) {
                if (empty($data->{$field->property})) {
                    continue;
                }

                $this->formData[$field->property] = $field->getValue($data->{$field->property} ?? $field->defaultValue);

                if ($field instanceof \FirstpointCh\Cream\View\Components\Form\BelongsTo) {
                    $model = $field->find($this->formData[$field->property] ?? null);

                    $this->belongsTo[$field->property]['label'] = optional($model)->{$field->labelField} ?? '';

                    if (!empty($model)) {
                        $updatedMethod = 'updatedFormData' . Str::studly($field->property);

                        if (method_exists($this, $updatedMethod)) {
                            $this->$updatedMethod(optional($model)->{$field->valueField});
                        }
                    }
                }
            }
        }
    }

    public function render()
    {
        return view('cream::livewire.views.create-form')
            ->layout('cream::layouts.app');
    }

    public function submit()
    {
        $this->save(
            $this->validate()['formData']
        );
    }

    public function updateBelongsTo($property, $label, $value)
    {
        $this->formData[$property] = $value;
        $this->belongsTo[$property]['label'] = $label;
        $this->belongsTo[$property]['value'] = null;

        $updatedMethod = 'updatedFormData' . Str::studly($property);

        if (method_exists($this, $updatedMethod)) {
            $this->$updatedMethod($value);
        }
    }
}
