<?php

namespace FirstpointCh\Cream\Http\Livewire\Views;

use Livewire\Component;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

abstract class EditForm extends Component
{
    use AuthorizesRequests;

    public string $title = '';

    public array $formData = [];

    public array $rules = [];

    public array $belongsTo = [];

    public function fields(): array
    {
        return [];
    }

    public function initializeForm($data): void
    {
        foreach ($this->fields() as $field) {
            $this->formData[$field->property] = $field->getValue($data->{$field->property});

            $this->rules['formData.' . $field->property] = $field->rules ?? 'nullable';

            if ($field instanceof \FirstpointCh\Cream\View\Components\Form\BelongsTo) {
                $model = $field->find($this->formData[$field->property]);

                $this->belongsTo[$field->property] = [
                    'label' => optional($model)->{$field->labelField},
                    'value' => '',
                ];
            }
        }
    }

    public function render()
    {
        return view('cream::livewire.views.create-form')
            ->layout('cream::layouts.app');
    }

    public function submit(): void
    {
        $this->save(
            $this->validate()['formData']
        );
    }

    public function updateBelongsTo($property, $label, $value): void
    {
        $this->formData[$property] = $value;
        $this->belongsTo[$property]['label'] = $label;
        $this->belongsTo[$property]['value'] = null;
    }
}
