<?php

namespace FirstpointCh\Cream;

use Illuminate\View\Component;

abstract class AbstractField extends Component
{
    public string $title;

    public string $property;

    public $rules;

    public $defaultValue;

    public string $helpText = '';

    /**
     * Create a new component instance.
     *
     * @return void
     */
    public function __construct(string $title, string $property)
    {
        $this->title = $title;
        $this->property = $property;
    }

    public static function make(string $title, string $property)
    {
        return new static($title, $property);
    }

    public function rules($rules)
    {
        $this->rules = $rules;

        return $this;
    }

    public function default($value)
    {
        $this->defaultValue = $value;

        return $this;
    }

    public function getValue($value)
    {
        return $value;
    }

    public function displayWhen(callable $callable)
    {
        $this->displayWhen = $callable;

        return $this;
    }

    public function help(string $help)
    {
        $this->helpText = $help;

        return $this;
    }
}
