<div x-show="mobileSidebarOpen" class="fixed inset-0 flex z-40 md:hidden" role="dialog" aria-modal="true">
    <div
        x-show="mobileSidebarOpen"
        x-transition:enter="transition-opacity ease-linear duration-300"
        x-transition:enter-start="opacity-0"
        x-transition:enter-end="opacity-100"
        x-transition:leave="transition-opacity ease-linear duration-300"
        x-transition:leave-start="opacity-100"
        x-transition:leave-end="opacity-0"
        class="fixed inset-0 bg-gray-600 bg-opacity-75"
        aria-hidden="true"
    ></div>

    <div
        x-show="mobileSidebarOpen"
        x-transition:enter="transition ease-in-out duration-300 transform"
        x-transition:enter-start="-translate-x-full"
        x-transition:enter-end="translate-x-0"
        x-transition:leave="transition ease-in-out duration-300 transform"
        x-transition:leave-start="translate-x-0"
        x-transition:leave-end="-translate-x-full"
        class="relative flex-1 flex flex-col max-w-xs w-full bg-gray-800"
    >
        <div
            x-show="mobileSidebarOpen"
            x-transition:enter="ease-in-out duration-300"
            x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100"
            x-transition:leave="ease-in-out duration-300"
            x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0"
            class="absolute top-0 right-0 -mr-12 pt-2"
        >
            <button class="ml-1 flex items-center justify-center h-10 w-10 rounded-full focus:outline-none focus:ring-2 focus:ring-inset focus:ring-white" x-on:click="mobileSidebarOpen = false">
                <span class="sr-only">Close sidebar</span>
                <!-- Heroicon name: outline/x -->
                <svg class="h-6 w-6 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>
        </div>

        <div class="flex-shrink-0 flex items-center px-4 bg-white pt-3 pb-3">
            @include('cream::partials.logo')
        </div>

        <div class="mt-5 flex-1 h-0 overflow-y-auto">
            <nav class="px-2 space-y-1">
                @foreach (resolve(\FirstpointCh\Cream\Cream::class)->navigation->items as $item)
                    @if ($item instanceof \FirstpointCh\Cream\NavItem)
                        <a href="{{ $item->url }}" class="{{ $item->isActive() || $item->isParent() ? 'bg-gray-900 text-white' : 'text-gray-300 hover:bg-gray-700 hover:text-white' }} group flex items-center px-2 py-2 text-base font-medium rounded-md">
                            <span class="{{ $item->isActive() ? 'text-gray-300' : 'text-gray-400 group-hover:text-gray-300' }} inline-block mr-4">
                                {!! $item->icon !!}
                            </span>

                            {{ $item->title }}
                        </a>
                    @else
                        {!! $item !!}
                    @endif
                @endforeach
            </nav>
        </div>
    </div>

    <div class="flex-shrink-0 w-14" aria-hidden="true">
        <!-- Dummy element to force sidebar to shrink to fit close icon -->
    </div>
</div>

<div class="hidden md:flex md:flex-shrink-0">
    <div class="flex flex-col w-64">
        <div class="flex flex-col h-0 flex-1">
            <div class="flex items-center h-16 flex-shrink-0 px-4 bg-white">
                @include('cream::partials.logo')
            </div>

            <div class="flex-1 flex flex-col overflow-y-auto">
                <nav class="flex-1 px-2 py-4 bg-gray-800 space-y-1">
                    @foreach (resolve(\FirstpointCh\Cream\Cream::class)->navigation->items as $item)
                        @if ($item instanceof \FirstpointCh\Cream\NavItem)
                            <a href="{{ $item->url }}" class="{{ $item->isActive() || $item->isParent() ? 'bg-gray-900 text-white' : 'text-gray-300 hover:bg-gray-700 hover:text-white' }} group flex items-center px-2 py-2 text-sm font-medium rounded-md">
                                <span class="{{ $item->isActive() ? 'text-gray-300' : 'text-gray-400 group-hover:text-gray-300' }} inline-block mr-3">
                                    {!! $item->icon !!}
                                </span>

                                {{ $item->title }}
                            </a>
                        @else
                            {!! $item !!}
                        @endif
                    @endforeach
                </nav>
            </div>
        </div>
    </div>
</div>
