<?php

namespace FirstpointCh\Cream;

class Navigation
{
    public array $items = [];

    public function item(string $title, string $url): self
    {
        $this->items[] = new NavItem($title, $url);

        return $this;
    }

    public function separator(): self
    {
        $this->items[] = '<div class="py-2"><hr /></div>';

        return $this;
    }

    public function icon(string $icon): self
    {
        $this->items[count($this->items) - 1]
            ->icon($icon);

        return $this;
    }
}
